function rgb = nhkIP_3x3_bilinear( bayer, cfaPattern )
%Bilinear demosaic algorithm 
%
%    rgb = Bilinear( bayer, cfaPattern )
%
% Demosaic'ing algorithms estimate missing color information by
% interpolation of the known color information across different color
% planes.  
%
% This routine implements a bilinear algorithm
%
% Copyright ImagEval Consultants, LLC, 2005.


% TODO:  Should check arguments, update programming style
%

[r,c,nPlanes] = size(bayer);

% There are three basic configurations for a color sensor in a 2x2 block.
% The sensor can occupy a single location, a pair of locations in a common row/col,
% or a pair of locations in diagonal positions.  We use the appropriate
% linear interpolation kernel in each of these cases.

for ii=1:nPlanes
    thisPlane = bayer(:,:,ii);
    l = (cfaPattern == ii);
        disp('nhkIP_3x3_bilinear for all color channel')
        rgb(:,:,ii) = conv2(thisPlane, [1/2 1 1 1/2]', 'valid');        
end

return;

% figure; imagesc(thisPlane); colormap(gray)
% figure; imagesc(rgb(:,:,ii)); colormap(gray)